// 2003/03/19 RichTextBoxContextMenu.cs
// Copyright (C) Ortana<ortaclient@hotmail.com>
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

using System;
using System.Windows.Forms;

namespace NTF.GUI
{
	/// <summary>
	/// RichTextBoxŎgpReLXgj[łB
	/// </summary>
	public class RichTextBoxContextMenu : ContextMenu
	{

		RichTextBox textBox;

		private System.Windows.Forms.MenuItem CCutMenu;
		private System.Windows.Forms.MenuItem CCopyMenu;
		private System.Windows.Forms.MenuItem CPasteMenu;
		private System.Windows.Forms.MenuItem CSaveMenu;
		private System.Windows.Forms.MenuItem CSelectAllMenu;

		public RichTextBoxContextMenu(RichTextBox textBox) 
		{
			this.textBox = textBox;
			InitializeMenu();
		}

		private void InitializeMenu()
		{
			this.CCutMenu = new System.Windows.Forms.MenuItem();
			this.CCopyMenu = new System.Windows.Forms.MenuItem();
			this.CPasteMenu = new System.Windows.Forms.MenuItem();
			this.CSaveMenu = new System.Windows.Forms.MenuItem();
			this.CSelectAllMenu = new System.Windows.Forms.MenuItem();

			// 
			// CCutMenu
			// 
			this.CCutMenu.Index = 0;
			this.CCutMenu.Shortcut = System.Windows.Forms.Shortcut.CtrlX;
			this.CCutMenu.ShowShortcut = false;
			this.CCutMenu.Text = "Jbg(&T)";
			this.CCutMenu.Click += new System.EventHandler(this.CCutMenu_Click);
			// 
			// CCopyMenu
			// 
			this.CCopyMenu.Index = 1;
			this.CCopyMenu.Shortcut = System.Windows.Forms.Shortcut.CtrlC;
			this.CCopyMenu.ShowShortcut = false;
			this.CCopyMenu.Text = "Rs[(&C)";
			this.CCopyMenu.Click += new System.EventHandler(this.CCopyMenu_Click);
			// 
			// CPasteMenu
			// 
			this.CPasteMenu.Index = 2;
			this.CPasteMenu.Shortcut = System.Windows.Forms.Shortcut.CtrlV;
			this.CPasteMenu.ShowShortcut = false;
			this.CPasteMenu.Text = "y[Xg(&P)";
			this.CPasteMenu.Click += new System.EventHandler(this.CPasteMenu_Click);
			// 
			// CSaveMenu
			// 
			this.CSaveMenu.Index = 3;
			this.CSaveMenu.Text = "I͈͂ۑ(&S)";
			this.CSaveMenu.Click += new System.EventHandler(this.CSaveMenu_Click);

			// 
			// CSelectAllMenu
			// 
			this.CSelectAllMenu.Index = 4;
			this.CSelectAllMenu.Shortcut = System.Windows.Forms.Shortcut.CtrlA;
			this.CSelectAllMenu.Text = "ׂđI(&A)";
			this.CSelectAllMenu.Click += new System.EventHandler(this.CSelectAllMenu_Click);

			// 
			// this
			// 
			this.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] 
																							 {
																								 this.CCutMenu,
																								 this.CCopyMenu,
																								 this.CPasteMenu,
																								 this.CSaveMenu,
																								 this.CSelectAllMenu
																							 });

			this.Popup += new System.EventHandler(this.contextMenu_Popup);
		}


		private void CSaveMenu_Click(object sender, System.EventArgs e)
		{
			NTF.HXD.DOC.Support.SaveSelectedText( this.textBox );
		}

		private void contextMenu_Popup(object sender, System.EventArgs e)
		{
			if( this.textBox.SelectedText.Length > 0 )
			{
				this.CCopyMenu.Enabled = true;
				this.CCutMenu.Enabled = true;
				this.CSaveMenu.Enabled = true;
			}
			else
			{
				this.CCopyMenu.Enabled = false;
				this.CCutMenu.Enabled	 = false;
				this.CSaveMenu.Enabled = false;
			}
		}

		private void CCutMenu_Click(object sender, System.EventArgs e)
		{
			this.textBox.Cut();
		}

		private void CCopyMenu_Click(object sender, System.EventArgs e)
		{
			this.textBox.Copy();
		}

		private void CPasteMenu_Click(object sender, System.EventArgs e)
		{
			DataFormats.Format myFormat = DataFormats.GetFormat(DataFormats.Text);

			if(textBox.CanPaste(myFormat))
			{
				textBox.Paste(myFormat);
			}
		}

		private void CSelectAllMenu_Click(object sender, System.EventArgs e)
		{
			this.textBox.SelectAll();
		}



	}
}
